  /*
   *  Object %name    : parser_atp_crys_sst_asym.c%
   *  State           :  %state%
   *  Creation date   :  Apr 06 2009
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief This file includes the DH parsing functions  
   *
   *  \version parser_atp_crys_sst_asym.c#1:csrc:1
   *  \author  taniam
   *  \remarks Copyright (C) 2004 by Discretix Technologies Ltd.
   *           All Rights reserved
   */
/************* Include Files ****************/
#include "CRYS_SST_SEP_ATP_Asym.h"
#include "parser_atp_crys_sst_asym.h"
#include "SST_SEP_TST.h"
#include "sep_utils.h"
#include "SST_SEP_TST_DEFINES.h"
//#include "parser_atp_sst_authentication.h"

/************************ Global Data ************************/
extern DxByte_t*       TST_Workspace;
extern DxUint32_t      TST_WorkspaceSizeInBytes ;
extern DxUint8_t*      GlobalMemBuff;
extern DxUint8_t*      CurrGlobalMemBuff;
extern TST_ATP_PassAuthTestDataStruct*        TST_ATP_PassAuthObjectTestData;

/******************** Private function  **********************/
/*****************************************************************************
* Function Name:
*  DX_SEP_PARSER_CRYS_SST_RSA
*  
* Inputs:
*  msg - message with all requested parameters.
*
* Outputs: 
*  DxUint32_t - Function error return
*
* Description:
* This function does the parsing for the external application SEPQA_CRYS_SST_RSA
* function and calls the SEP function.
*
* Algorithm: 
* 1. call to DX_SEP_MNG_SSTGetWorkspaceParams
* 2. allocate memory for GlobalMemBuff for all next needed allocation in the test
* 3. call QA SEP function
* 4. free allocated GlobalMemBuff
* 5. end SEP message and return
******************************************************************************/
DxUint32_t DX_SEP_PARSER_CRYS_SST_RSA(DxUint32_t* msg)
{
     /********* Variables Definitions ************/
     DxUint32_t    SEP_Error = DX_SUCCESS;

    TST_Workspace = DX_NULL;

    /*1. call to DX_SEP_MNG_SSTGetWorkspaceParams*/
    SEP_Error = DX_SEP_MNG_SSTGetWorkspaceParams(&TST_Workspace,
                                                  &TST_WorkspaceSizeInBytes);

    if (TST_Workspace == DX_NULL)
     {
        TST_CheckErrorReturn(SEP_Error,"DX_SEP_MNG_SSTGetWorkspaceParams");
        goto End;
     }

    /*2. allocate memory for GlobalMemBuff for all next needed allocation in the test*/
    GlobalMemBuff = DX_VOS_MemMalloc(sizeof(DxUint8_t)*TST_MAX_SEP_WORKSPACE_MEM);

    if (GlobalMemBuff == DX_NULL)
     {
        TST_CheckErrorReturn(1,"DX_VOS_MemMalloc GlobalMemBuff");
        goto End;
     }
    CurrGlobalMemBuff = GlobalMemBuff;

    /*3. allocate buffer from GlobalMemBuff to data struct*/
    if  ((CurrGlobalMemBuff+sizeof(TST_ATP_PassAuthTestDataStruct))>(GlobalMemBuff+TST_MAX_SEP_WORKSPACE_MEM))
    {
        TST_CheckErrorReturn(1,"TST_ATP_PassAuthObjectTestData memory allocation");
        goto End;
    }
    else
    {
        TST_ATP_PassAuthObjectTestData = (TST_ATP_PassAuthTestDataStruct*)CurrGlobalMemBuff;
        CurrGlobalMemBuff = CurrGlobalMemBuff+sizeof(TST_ATP_PassAuthTestDataStruct);
    }

     /*4. extract parameters from the message*/
    DX_VOS_FastMemCpy(&TST_ATP_PassAuthObjectTestData[0], &msg[DX_SEP_HOST_SEP_BASE_MSG_OFFSET], sizeof(TST_ATP_PassAuthTestDataStruct));



      /* 3. call QA SEP function */
     /***************************/
      SEP_Error = SEPQA_CRYS_SST_RSA();
      SEP_Error = TST_CheckErrorReturn(SEP_Error,"SEPQA_CRYS_SST_RSA");

End:
    /* 4. free allocated GlobalMemBuff */
    DX_VOS_MemFree(GlobalMemBuff);

    /* 5. end SEP message and return */
    msg[DX_SEP_HOST_SEP_PROTOCOL_MSG_OP_CODE_OFFSET] = DX_SEP_HOST_SEP_PROTOCOL_CRYS_SST_RSA_OP_CODE;
    return DX_SEP_EndMessage(msg, SEP_Error, 4);
}
/*****************************************************************************
* Function Name:
*  DX_SEP_PARSER_CRYS_SST_RSA_OAEP_ENCDEC
*  
* Inputs:
*  msg - message with all requested parameters.
*
* Outputs: 
*  DxUint32_t - Function error return
*
* Description:
* This function does the parsing for the external application SEPQA_CRYS_SST_OAEP_ENCDEC
* function and calls the SEP function.
*
* Algorithm: 
* 1. call to DX_SEP_MNG_SSTGetWorkspaceParams
* 2. allocate memory for GlobalMemBuff for all next needed allocation in the test
* 3. call QA SEP function
* 4. free allocated GlobalMemBuff
* 5. end SEP message and return
******************************************************************************/
DxUint32_t DX_SEP_PARSER_CRYS_SST_RSA_OAEP_ENCDEC(DxUint32_t* msg)
{
     /********* Variables Definitions ************/
     DxUint32_t    SEP_Error = DX_SUCCESS;

    TST_Workspace = DX_NULL;

    /* 1. call to DX_SEP_MNG_SSTGetWorkspaceParams*/
    SEP_Error = DX_SEP_MNG_SSTGetWorkspaceParams(&TST_Workspace,
                                                &TST_WorkspaceSizeInBytes);

    if (TST_Workspace == DX_NULL)
     {
        TST_CheckErrorReturn(SEP_Error,"DX_SEP_MNG_SSTGetWorkspaceParams");
        goto End;
     }

    /*2. allocate memory for GlobalMemBuff for all next needed allocation in the test*/
    GlobalMemBuff = DX_VOS_MemMalloc(sizeof(DxUint8_t)*TST_MAX_SEP_WORKSPACE_MEM);

    if (GlobalMemBuff == DX_NULL)
     {
        TST_CheckErrorReturn(1,"DX_VOS_MemMalloc GlobalMemBuff");
        goto End;
     }
    CurrGlobalMemBuff = GlobalMemBuff;

    /*3. allocate buffer from GlobalMemBuff to data struct*/
    if  ((CurrGlobalMemBuff+sizeof(TST_ATP_PassAuthTestDataStruct))>(GlobalMemBuff+TST_MAX_SEP_WORKSPACE_MEM))
    {
        TST_CheckErrorReturn(1,"TST_ATP_PassAuthObjectTestData memory allocation");
        goto End;
    }
    else
    {
        TST_ATP_PassAuthObjectTestData = (TST_ATP_PassAuthTestDataStruct*)CurrGlobalMemBuff;
        CurrGlobalMemBuff = CurrGlobalMemBuff+sizeof(TST_ATP_PassAuthTestDataStruct);
    }

     /*4. extract parameters from the message*/
    DX_VOS_FastMemCpy(&TST_ATP_PassAuthObjectTestData[0], &msg[DX_SEP_HOST_SEP_BASE_MSG_OFFSET], sizeof(TST_ATP_PassAuthTestDataStruct));


      /* 5. call QA SEP function */
     /***************************/
      SEP_Error = SEPQA_CRYS_SST_RSA_OAEP_ENCDEC();
      SEP_Error = TST_CheckErrorReturn(SEP_Error,"SEPQA_CRYS_SST_RSA_RSA_OAEP_ENCDEC");

End:
    /* 6. free allocated GlobalMemBuff*/
    DX_VOS_MemFree(GlobalMemBuff);

    /* 7. end SEP message and return */
    msg[DX_SEP_HOST_SEP_PROTOCOL_MSG_OP_CODE_OFFSET] = DX_SEP_HOST_SEP_PROTOCOL_CRYS_SST_RSA_OAEP_ENCDEC_OP_CODE;
    return DX_SEP_EndMessage(msg, SEP_Error, 4);
}
/*****************************************************************************
* Function Name:
*  DX_SEP_PARSER_CRYS_SST_RSA_PRIM
*  
* Inputs:
*  msg - message with all requested parameters.
*
* Outputs: 
*  DxUint32_t - Function error return
*
* Description:
* This function does the parsing for the external application SEPQA_RSA_Prim
* function and calls the SEP function.
*
* Algorithm: 
* 1. call to DX_SEP_MNG_SSTGetWorkspaceParams
* 2. allocate memory for GlobalMemBuff for all next needed allocation in the test
* 3. call QA SEP function
* 4. free allocated GlobalMemBuff
* 5. end SEP message and return
******************************************************************************/

DxUint32_t DX_SEP_PARSER_CRYS_SST_RSA_PRIM(DxUint32_t* msg)
{
     /********* Variables Definitions ************/
     DxUint32_t    SEP_Error = DX_SUCCESS;

    TST_Workspace = DX_NULL;

    /* 1. call to DX_SEP_MNG_SSTGetWorkspaceParams*/
    SEP_Error = DX_SEP_MNG_SSTGetWorkspaceParams(&TST_Workspace,
                                                 &TST_WorkspaceSizeInBytes);

    if (TST_Workspace == DX_NULL)
     {
        TST_CheckErrorReturn(SEP_Error,"DX_SEP_MNG_SSTGetWorkspaceParams");
        goto End;
     }

    /*2. allocate memory for GlobalMemBuff for all next needed allocation in the test*/
    GlobalMemBuff = DX_VOS_MemMalloc(sizeof(DxUint8_t)*TST_MAX_SEP_WORKSPACE_MEM);

    if (GlobalMemBuff == DX_NULL)
     {
        TST_CheckErrorReturn(1,"DX_VOS_MemMalloc GlobalMemBuff");
        goto End;
     }
    CurrGlobalMemBuff = GlobalMemBuff;

    /*3. allocate buffer from GlobalMemBuff to data struct*/
    if  ((CurrGlobalMemBuff+sizeof(TST_ATP_PassAuthTestDataStruct))>(GlobalMemBuff+TST_MAX_SEP_WORKSPACE_MEM))
    {
        TST_CheckErrorReturn(1,"TST_ATP_PassAuthObjectTestData memory allocation");
        goto End;
    }
    else
    {
        TST_ATP_PassAuthObjectTestData = (TST_ATP_PassAuthTestDataStruct*)CurrGlobalMemBuff;
        CurrGlobalMemBuff = CurrGlobalMemBuff+sizeof(TST_ATP_PassAuthTestDataStruct);
    }

     /*4. extract parameters from the message*/
    DX_VOS_FastMemCpy(&TST_ATP_PassAuthObjectTestData[0], &msg[DX_SEP_HOST_SEP_BASE_MSG_OFFSET], sizeof(TST_ATP_PassAuthTestDataStruct));

    /* 3. call QA SEP function */
    /***************************/
    SEP_Error = SEPQA_CRYS_SST_RSA_Prim();
    SEP_Error = TST_CheckErrorReturn(SEP_Error,"SEPQA_CRYS_SST_RSA_RSA_OAEP_ENCDEC");


End:
    /* 4. free allocated GlobalMemBuff */
    DX_VOS_MemFree(GlobalMemBuff);

    /* 5. end SEP message and return */
    msg[DX_SEP_HOST_SEP_PROTOCOL_MSG_OP_CODE_OFFSET] = DX_SEP_HOST_SEP_PROTOCOL_CRYS_SST_RSA_PRIM_OP_CODE;
    return DX_SEP_EndMessage(msg, SEP_Error, 4);

}



